clear all
close all
clc


fgear = [119.9866 -251.2475]; % [N]
load = norm(fgear, 2)/2;
angolo = rad2deg(mod(atan2(fgear(2), fgear(1)), 2*pi)); %[deg]

mu = 14e-3; %[Pa*s]

xbear = 0.001; ybear = -0.023; %no wear, no displ  
e = sqrt( xbear^2 + ybear^2 );
GAMMA =  rad2deg(mod(atan2(ybear, xbear), 2*pi));

R = 4.5; %define gear drain radius [mm]
AR = 0.95;
L = AR*2*R;

Clear = 0.0245; %define tooth tip clearance with casing [mm]

Ns = 3350/60; %[RPMR]/60 ((positiva per definizione all'interno della function))

[ecc,attitude_angle] = JBe(R*0.001,L*0.001,Clear*0.001,Ns,load,mu);

ecc = ecc * 1000 %[mm]
angolo_ecc = angolo - attitude_angle

xbear2 = ecc*cosd(angolo_ecc);
ybear2 = ecc*sind(angolo_ecc);

ecc1_GAMMA2 = [e, ecc, abs(e-ecc)/abs(e)*100; GAMMA, angolo_ecc, abs(GAMMA-angolo_ecc)/abs(GAMMA)*100]

